<?php
// 🔐 Load database and email libraries
require 'db_config.php';
require 'PHPMailer/PHPMailer.php';
require 'PHPMailer/SMTP.php';
require 'PHPMailer/Exception.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

// 📥 Get JSON input from frontend
$data = json_decode(file_get_contents("php://input"), true);

// 🛑 Validate input
if (!$data || !isset($data['email']) || !isset($data['amount'])) {
  http_response_code(400);
  echo json_encode(["error" => "Invalid data"]);
  exit;
}

try {
  // 💾 Save donation to database
  $stmt = $pdo->prepare("INSERT INTO donations (
    amount, currency, name, last_name, email, message,
    anonymous, mailing_list, country, stripe_id, timestamp
  ) VALUES (
    :amount, :currency, :name, :last_name, :email, :message,
    :anonymous, :mailing_list, :country, :stripe_id, NOW()
  )");

  $stmt->execute([
    ":amount" => $data["amount"],
    ":currency" => $data["currency"] ?? 'USD',
    ":name" => $data["name"] ?? '',
    ":last_name" => $data["lastName"] ?? '',
    ":email" => $data["email"],
    ":message" => $data["message"] ?? '',
    ":anonymous" => !empty($data["anonymous"]) ? 1 : 0,
    ":mailing_list" => !empty($data["mailingList"]) ? 1 : 0,
    ":country" => $data["country"] ?? '',
    ":stripe_id" => $data["stripe_id"] ?? null // Optional: Stripe paymentIntent ID
  ]);

  // 📧 Send email receipt
  $mail = new PHPMailer(true);
  $mail->isSMTP();
  $mail->Host = 'smtp.gmail.com';
  $mail->SMTPAuth = true;
  $mail->Username = 'your-email@gmail.com'; // Replace with TRD email
  $mail->Password = 'your-app-password';    // Use Gmail App Password
  $mail->SMTPSecure = 'tls';
  $mail->Port = 587;

  $mail->setFrom('your-email@gmail.com', 'Tanzania Rugby Development');
  $mail->addAddress($data['email'], $data['name'] . ' ' . $data['lastName']);

  $mail->isHTML(true);
  $mail->Subject = 'Thank You for Your Donation';
  $mail->Body = "
    <h3>Dear {$data['name']},</h3>
    <p>Thank you for supporting youth rugby in Tanzania!</p>
    <p><strong>Amount:</strong> {$data['amount']} {$data['currency']}</p>
    <p><strong>Message:</strong> {$data['message']}</p>
    <p>We appreciate your generosity and commitment to our mission.</p>
    <br>
    <p>Warm regards,<br>Tanzania Rugby Development</p>
  ";

  $mail->send();

  echo json_encode(["success" => true]);
} catch (Exception $e) {
  error_log("Email error: " . $mail->ErrorInfo);
  http_response_code(500);
  echo json_encode(["error" => $e->getMessage()]);
}
?>