<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Donate | Tanzania Rugby Development</title>
  <link rel="stylesheet" href="style/style.css" />
  <link rel="stylesheet" href="style/donate.css" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" />
  <script src="https://js.stripe.com/v3/"></script>
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/choices.js/public/assets/styles/choices.min.css" />
  <script src="https://cdn.jsdelivr.net/npm/choices.js/public/assets/scripts/choices.min.js"></script>
</head>
<body>

<div id="donation-popup" class="popup-overlay" style="display:flex;">
  <div class="popup-content">
    <button class="cancel-btn" onclick="window.location.href='support us.html'">×</button>
<script>
  function confirmExit() {
    if (confirm("Are you sure you want to cancel and return to the Support Us page?")) {
      window.location.href = 'support_us.html';
    }
  }
</script>
    <div id="step-indicator" class="step-indicator">Step 1 of 3</div>

    <!-- STEP 1 -->
    <div class="donation-step" id="step-1">
      <button class="cancel-btn" onclick="closeDonationModal()">×</button>
      <h2>Choose Your Donation</h2>
      <select class="currency-select" id="currency-select">
        <option value="USD">$ USD</option>
        <option value="TZS">TSh TZS</option>
        <option value="EUR">€ EUR</option>
        <option value="GBP">£ GBP</option>
      </select>

      <div class="donation-type">
        <button class="type-btn active" data-type="one-time">One-Time</button>
        <button class="type-btn" data-type="monthly">Monthly</button>
      </div>

      <div class="amount-options">
        <button class="amount-btn" data-usd="20">$20</button>
        <button class="amount-btn active" data-usd="50">$50</button>
        <button class="amount-btn" data-usd="100">$100</button>
        <input type="text" placeholder="Custom amount" class="custom-amount" id="custom-amount" />
        <div id="amount-warning" style="color:red; font-size:0.9em; display:none;">Please enter numbers only.</div>
      </div>

      <button class="next-btn" id="step1-next">Next</button>

      <div class="payment-icons">
        <i class="fab fa-cc-visa"></i>
        <i class="fab fa-cc-mastercard"></i>
        <i class="fab fa-cc-amex"></i>
        <i class="fab fa-cc-discover"></i>
        <i class="fab fa-google-pay"></i>
        <i class="fab fa-apple-pay"></i>
      </div>
    </div>

    <!-- STEP 2 -->
    <div class="donation-step" id="step-2" style="display:none;">
      <button class="back-btn" onclick="goToStep(1)">← Back</button>
      <button class="cancel-btn" onclick="closeDonationModal()">×</button>
      <h2>Your Details</h2>
      <input type="text" id="first-name" placeholder="First Name *" required />
      <input type="text" id="last-name" placeholder="Last Name *" required />
      <input type="email" id="email" placeholder="Email *" required />
      <textarea id="message" placeholder="Your Message (optional)"></textarea>
      <label><input type="checkbox" id="anonymous-checkbox" /> Keep my donation anonymous</label><br />
      <label><input type="checkbox" id="mailing-list-checkbox" /> Add me to the mailing list</label>
      <button class="next-btn" onclick="goToStep(3)">Next</button>
    </div>

    <!-- STEP 3 -->
<div class="donation-step" id="step-3" style="display:none;">
  <button class="back-btn" onclick="goToStep(2)">← Back</button>
 <button class="cancel-btn" onclick="closeDonationModal()">×</button>
  <h2>Confirm & Pay</h2>

  <form id="payment-form">
    <label for="card-number">Card Number</label>
    <div class="card-input-wrapper">
      <input type="text" id="card-number" maxlength="19" placeholder="1234 5678 9012 3456" />
      <img id="card-logo" src="" alt="" style="height:24px; margin-left:10px; display:none;" />
    </div>

    <label for="expiry">Expiration Date</label>
    <input type="text" id="expiry" maxlength="5" placeholder="MM/YY" />

    <label for="cvv">Security Code (CVV)</label>
    <input type="text" id="cvv" maxlength="3" placeholder="123" />

    <div id="card-element" style="margin-bottom: 10px;"></div>

<div class="country-select-wrapper">
   <label for="country-select">Select Country</label>
    <select id="country-select" style="width: 100%;">
      <option value="">Select your country</option>
      <option value="Afghanistan">Afghanistan</option>
      <option value="Albania">Albania</option>
      <option value="Algeria">Algeria</option>
      <option value="Andorra">Andorra</option>
      <option value="Angola">Angola</option>
      <option value="Argentina">Argentina</option>
      <option value="Armenia">Armenia</option>
      <option value="Australia">Australia</option>
      <option value="Austria">Austria</option>
      <option value="Azerbaijan">Azerbaijan</option>
      <option value="Bahamas">Bahamas</option>
      <option value="Bahrain">Bahrain</option>
      <option value="Bangladesh">Bangladesh</option>
      <option value="Barbados">Barbados</option>
      <option value="Belarus">Belarus</option>
      <option value="Belgium">Belgium</option>
      <option value="Belize">Belize</option>
      <option value="Benin">Benin</option>
      <option value="Bhutan">Bhutan</option>
      <option value="Bolivia">Bolivia</option>
      <option value="Bosnia and Herzegovina">Bosnia and Herzegovina</option>
      <option value="Botswana">Botswana</option>
      <option value="Brazil">Brazil</option>
      <option value="Brunei">Brunei</option>
      <option value="Bulgaria">Bulgaria</option>
      <option value="Burkina Faso">Burkina Faso</option>
      <option value="Burundi">Burundi</option>
      <option value="Cambodia">Cambodia</option>
      <option value="Cameroon">Cameroon</option>
      <option value="Canada">Canada</option>
      <option value="Cape Verde">Cape Verde</option>
      <option value="Central African Republic">Central African Republic</option>
      <option value="Chad">Chad</option>
      <option value="Chile">Chile</option>
      <option value="China">China</option>
      <option value="Colombia">Colombia</option>
      <option value="Comoros">Comoros</option>
      <option value="Congo">Congo</option>
      <option value="Costa Rica">Costa Rica</option>
      <option value="Croatia">Croatia</option>
      <option value="Cuba">Cuba</option>
      <option value="Cyprus">Cyprus</option>
      <option value="Czech Republic">Czech Republic</option>
      <option value="Denmark">Denmark</option>
      <option value="Djibouti">Djibouti</option>
      <option value="Dominica">Dominica</option>
      <option value="Dominican Republic">Dominican Republic</option>
      <option value="Ecuador">Ecuador</option>
      <option value="Egypt">Egypt</option>
      <option value="El Salvador">El Salvador</option>
      <option value="Equatorial Guinea">Equatorial Guinea</option>
      <option value="Eritrea">Eritrea</option>
      <option value="Estonia">Estonia</option>
      <option value="Eswatini">Eswatini</option>
      <option value="Ethiopia">Ethiopia</option>
      <option value="Fiji">Fiji</option>
      <option value="Finland">Finland</option>
      <option value="France">France</option>
      <option value="Gabon">Gabon</option>
      <option value="Gambia">Gambia</option>
      <option value="Georgia">Georgia</option>
      <option value="Germany">Germany</option>
      <option value="Ghana">Ghana</option>
      <option value="Greece">Greece</option>
      <option value="Grenada">Grenada</option>
      <option value="Guatemala">Guatemala</option>
      <option value="Guinea">Guinea</option>
      <option value="Guinea-Bissau">Guinea-Bissau</option>
      <option value="Guyana">Guyana</option>
      <option value="Haiti">Haiti</option>
      <option value="Honduras">Honduras</option>
      <option value="Hungary">Hungary</option>
      <option value="Iceland">Iceland</option>
      <option value="India">India</option>
      <option value="Indonesia">Indonesia</option>
      <option value="Iran">Iran</option>
      <option value="Iraq">Iraq</option>
      <option value="Ireland">Ireland</option>
      <option value="Israel">Israel</option>
      <option value="Italy">Italy</option>
      <option value="Jamaica">Jamaica</option>
      <option value="Japan">Japan</option>
      <option value="Jordan">Jordan</option>
      <option value="Kazakhstan">Kazakhstan</option>
      <option value="Kenya">Kenya</option>
      <option value="Kiribati">Kiribati</option>
      <option value="Kuwait">Kuwait</option>
      <option value="Kyrgyzstan">Kyrgyzstan</option>
      <option value="Laos">Laos</option>
      <option value="Latvia">Latvia</option>
      <option value="Lebanon">Lebanon</option>
      <option value="Lesotho">Lesotho</option>
      <option value="Liberia">Liberia</option>
      <option value="Libya">Libya</option>
      <option value="Liechtenstein">Liechtenstein</option>
      <option value="Lithuania">Lithuania</option>
      <option value="Luxembourg">Luxembourg</option>
      <option value="Madagascar">Madagascar</option>
      <option value="Malawi">Malawi</option>
      <option value="Malaysia">Malaysia</option>
      <option value="Maldives">Maldives</option>
      <option value="Mali">Mali</option>
      <option value="Malta">Malta</option>
      <option value="Marshall Islands">Marshall Islands</option>
      <option value="Mauritania">Mauritania</option>
      <option value="Mauritius">Mauritius</option>
      <option value="Mexico">Mexico</option>
      <option value="Micronesia">Micronesia</option>
      <option value="Moldova">Moldova</option>
      <option value="Monaco">Monaco</option>
      <option value="Mongolia">Mongolia</option>
      <option value="Montenegro">Montenegro</option>
      <option value="Morocco">Morocco</option>
      <option value="Mozambique">Mozambique</option>
      <option value="Myanmar">Myanmar</option>
      <option value="Namibia">Namibia</option>
      <option value="Nauru">Nauru</option>
      <option value="Nepal">Nepal</option>
      <option value="Netherlands">Netherlands</option>
      <option value="New Zealand">New Zealand</option>
      <option value="Nicaragua">Nicaragua</option>
      <option value="Niger">Niger</option>
      <option value="Nigeria">Nigeria</option>
      <option value="North Korea">North Korea</option>
      <option value="North Macedonia">North Macedonia</option>
      <option value="Norway">Norway</option>
      <option value="Oman">Oman</option>
      <option value="Pakistan">Pakistan</option>
      <option value="Palau">Palau</option>
      <option value="Panama">Panama</option>
      <option value="Papua New Guinea">Papua New Guinea</option>
      <option value="Paraguay">Paraguay</option>
      <option value="Peru">Peru</option>
      <option value="Philippines">Philippines</option>
      <option value="Poland">Poland</option>
      <option value="Portugal">Portugal</option>
      <option value="Qatar">Qatar</option>
      <option value="Romania">Romania</option>
      <option value="Russia">Russia</option>
      <option value="Rwanda">Rwanda</option>
      <option value="Saint Kitts and Nevis">Saint Kitts and Nevis</option>
      <option value="Saint Lucia">Saint Lucia</option>
      <option value="Saint Vincent and the Grenadines">Saint Vincent and the Grenadines</option>
      <option value="Samoa">Samoa</option>
      <option value="San Marino">San Marino</option>
      <option value="Sao Tome and Principe">Sao Tome and Principe</option>
      <option value="Saudi Arabia">Saudi Arabia</option>
      <option value="Senegal">Senegal</option>
      <option value="Serbia">Serbia</option>
      <option value="Seychelles">Seychelles</option>
      <option value="Sierra Leone">Sierra Leone</option>
      <option value="Singapore">Singapore</option>
      <option value="Slovakia">Slovakia</option>
      <option value="Slovenia">Slovenia</option>
      <option value="Solomon Islands">Solomon Islands</option>
      <option value="Somalia">Somalia</option>
      <option value="South Africa">South Africa</option>
      <option value="South Korea">South Korea</option>
      <option value="South Sudan">South Sudan</option>
      <option value="Spain">Spain</option>
      <option value="Sri Lanka">Sri Lanka</option>
      <option value="Sudan">Sudan</option>
      <option value="Suriname">Suriname</option>
      <option value="Sweden">Sweden</option>
      <option value="Switzerland">Switzerland</option>
      <option value="Syria">Syria</option>
      <option value="Taiwan">Taiwan</option>
      <option value="Tajikistan">Tajikistan</option>
      <option value="Tanzania">Tanzania</option>
      <option value="Thailand">Thailand</option>
      <option value="Timor-Leste">Timor-Leste</option>
      <option value="Togo">Togo</option>
      <option value="Tonga">Tonga</option>
      <option value="Trinidad and Tobago">Trinidad and Tobago</option>
      <option value="Tunisia">Tunisia</option>
      <option value="Turkey">Turkey</option>
      <option value="Turkmenistan">Turkmenistan</option>
      <option value="Tuvalu">Tuvalu</option>
      <option value="Uganda">Uganda</option>
      <option value="Ukraine">Ukraine</option>
      <option value="United Arab Emirates">United Arab Emirates</option>
      <option value="United Kingdom">United Kingdom</option>
      <option value="United States">United States</option>
      <option value="Uruguay">Uruguay</option>
      <option value="Uzbekistan">Uzbekistan</option>
      <option value="Vanuatu">Vanuatu</option>
      <option value="Vatican City">Vatican City</option>
      <option value="Venezuela">Venezuela</option>
      <option value="Vietnam">Vietnam</option>
      <option value="Yemen">Yemen</option>
      <option value="Zambia">Zambia</option>
      <option value="Zimbabwe">Zimbabwe</option>
    </select>
</div>
    <!-- Error Message -->
    <div id="card-errors" role="alert" style="color:red; margin-top:10px;"></div>

    <!-- Total -->
    <p class="donation-summary">Total: <span id="total-value">$50.00</span></p>
    <button class="next-btn" id="donate-button">Donate</button>
  </form>
</div>


<!-- EMBEDDED JAVASCRIPT -->
<script>
function initDonationForm() {
  let selectedCurrency = "USD";
  let selectedAmountUSD = 50;
  let isMonthly = false;

  const exchangeRates = { USD: 1, TZS: 2430, EUR: 0.8578, GBP: 0.7438 };
  const currencySymbols = { USD: "$", TZS: "TSh", EUR: "€", GBP: "£" };

  function updateAmountButtons() {
    document.querySelectorAll(".amount-btn").forEach(btn => {
      const usd = parseInt(btn.dataset.usd);
      const converted = Math.round(usd * exchangeRates[selectedCurrency]);
      btn.textContent = `${currencySymbols[selectedCurrency]}${converted}`;
    });
  }

  function selectAmount(usd) {
    selectedAmountUSD = usd;
    const converted = Math.round(usd * exchangeRates[selectedCurrency]);
    document.getElementById("custom-amount").value = converted;
    document.querySelectorAll(".amount-btn").forEach(btn => btn.classList.remove("active"));
    document.querySelector(`.amount-btn[data-usd="${usd}"]`).classList.add("active");
    updateTotalDisplay();
  }

  function goToStep(step) {
    for (let i = 1; i <= 3; i++) {
      document.getElementById("step-" + i).style.display = i === step ? "block" : "none";
    }
    document.getElementById("step-indicator").textContent = `Step ${step} of 3`;
    updateTotalDisplay();
  }

  function updateTotalDisplay() {
    const converted = Math.round(selectedAmountUSD * exchangeRates[selectedCurrency]);
    document.getElementById("total-value").textContent = `${currencySymbols[selectedCurrency]}${converted}`;
    document.getElementById("donate-button").textContent = `Donate ${currencySymbols[selectedCurrency]}${converted}`;
  }

  document.getElementById("currency-select").addEventListener("change", e => {
    selectedCurrency = e.target.value;
    updateAmountButtons();
    selectAmount(selectedAmountUSD);
  });

  document.querySelectorAll(".amount-btn").forEach(btn => {
    btn.addEventListener("click", () => {
      selectAmount(parseInt(btn.dataset.usd));
    });
  });

  document.querySelectorAll(".type-btn").forEach(btn => {
    btn.addEventListener("click", () => {
      document.querySelectorAll(".type-btn").forEach(b => b.classList.remove("active"));
      btn.classList.add("active");
      isMonthly = btn.dataset.type === "monthly";
    });
  });

  document.getElementById("custom-amount").addEventListener("input", e => {
    const value = e.target.value;
    const warning = document.getElementById("amount-warning");
    if (/[^0-9]/.test(value)) {
      warning.style.display = "block";
      e.target.value = value.replace(/[^0-9]/g, "");
    } else {
      warning.style.display = "none";
      selectedAmountUSD = Math.round(parseFloat(value) / exchangeRates[selectedCurrency]);
      updateTotalDisplay();
    }
  });

  document.getElementById("step1-next").addEventListener("click", () => {
    const amount = document.getElementById("custom-amount").value;
    if (!amount || isNaN(amount) || parseFloat(amount) <= 0) {
      alert("Please enter a valid donation amount.");
      return;
    }
    goToStep(2);
  });

  document.querySelector(".donation-step #step-2 .next-btn").addEventListener("click", () => {
    goToStep(3);
  });

  const stripe = Stripe("pk_test_YourPublishableKeyHere");
  const elements = stripe.elements();
  const card = elements.create("card");
  card.mount("#card-element");

  card.on("change", event => {
    document.getElementById("card-errors").textContent = event.error ? event.error.message : "";
  });

  document.getElementById("donate-button").addEventListener("click", async (e) => {
    e.preventDefault();

    const amount = Math.round(selectedAmountUSD * exchangeRates[selectedCurrency]);
    const currency = selectedCurrency;
    const email = document.getElementById("email").value;
    const name = document.getElementById("first-name").value + " " + document.getElementById("last-name").value;
    const message = document.getElementById("message").value;
    const anonymous = document.getElementById("anonymous-checkbox").checked;
    const country = document.getElementById("country-select").value;

    const res = await fetch("donation_process.php", {
      method: "POST",
      headers: { "Content-Type": "application/json" },
      body: JSON.stringify({ amount, currency, email, name, message, anonymous, country, isMonthly })
    });

    const data = await res.json();
    if (!data.success) {
      alert("Error: " + data.error);
      return;
    }

    const result = await stripe.confirmCardPayment(data.client_secret, {
      payment_method: {
        card: card,
        billing_details: { name, email }
      }
    });

    if (result.error) {
      document.getElementById("card-errors").textContent = result.error.message;
    } else if (result.paymentIntent.status === "succeeded") {
      alert("Thank you! Your donation was successful.");
      closeDonationModal();
    }
  });

  document.getElementById("card-number").addEventListener("input", function () {
    const value = this.value.replace(/\s+/g, "");
    const logo = document.getElementById("card-logo");

    let type = "";
    if (/^4/.test(value)) type = "visa";
    else if (/^5[1-5]/.test(value)) type = "mastercard";
    else if (/^3[47]/.test(value)) type = "amex";
    else if (/^6/.test(value)) type = "discover";

    if (type) {
      logo.src = `images/${type}.png`;
      logo.style.display = "inline";
    } else {
      logo.style.display = "none";
    }
  });

  document.getElementById("expiry").addEventListener("input", function () {
    let value = this.value.replace(/\D/g, "");
    if (value.length >= 3) {
      value = value.slice(0, 2) + "/" + value.slice(2, 4);
    }
    this.value = value.slice(0, 5);
  });

  document.getElementById("cvv").addEventListener("input", function () {
    this.value = this.value.replace(/\D/g, "").slice(0, 3);
  });

  const select = document.getElementById("country-select");
  const countries = [
    "Afghanistan", "Albania", "Algeria", "Andorra", "Angola", "Argentina", "Armenia", "Australia", "Austria", "Azerbaijan",
    "Bahamas", "Bahrain", "Bangladesh", "Barbados", "Belarus", "Belgium", "Belize", "Benin", "Bhutan", "Bolivia",
    "Bosnia and Herzegovina", "Botswana", "Brazil", "Brunei", "Bulgaria", "Burkina Faso", "Burundi", "Cambodia", "Cameroon", "Canada",
    "Cape Verde", "Central African Republic", "Chad", "Chile", "China", "Colombia", "Comoros", "Congo", "Costa Rica", "Croatia",
    "Cuba", "Cyprus", "Czech Republic", "Denmark", "Djibouti", "Dominica", "Dominican Republic", "Ecuador", "Egypt", "El Salvador",
    "Equatorial Guinea", "Eritrea", "Estonia", "Eswatini", "Ethiopia", "Fiji", "Finland", "France", "Gabon", "Gambia",
    "Georgia", "Germany", "Ghana", "Greece", "Grenada", "Guatemala", "Guinea", "Guinea-Bissau", "Guyana", "Haiti",
    "Honduras", "Hungary", "Iceland", "India", "Indonesia", "Iran", "Iraq", "Ireland", "Israel", "Italy",
    "Jamaica", "Japan", "Jordan", "Kazakhstan", "Kenya", "Kiribati", "Kuwait", "Kyrgyzstan", "Laos", "Latvia",
    "Lebanon", "Lesotho", "Liberia", "Libya", "Liechtenstein", "Lithuania", "Luxembourg", "Madagascar", "Malawi", "Malaysia",
    "Maldives", "Mali", "Malta", "Marshall Islands", "Mauritania", "Mauritius", "Mexico", "Micronesia", "Moldova", "Monaco",
        "Mongolia", "Montenegro", "Morocco", "Mozambique", "Myanmar", "Namibia", "Nauru", "Nepal", "Netherlands", "New Zealand",
    "Nicaragua", "Niger", "Nigeria", "North Korea", "North Macedonia", "Norway", "Oman", "Pakistan", "Palau", "Panama",
    "Papua New Guinea", "Paraguay", "Peru", "Philippines", "Poland", "Portugal", "Qatar", "Romania", "Russia", "Rwanda",
    "Saint Kitts and Nevis", "Saint Lucia", "Saint Vincent and the Grenadines", "Samoa", "San Marino", "Sao Tome and Principe",
    "Saudi Arabia", "Senegal", "Serbia", "Seychelles", "Sierra Leone", "Singapore", "Slovakia", "Slovenia", "Solomon Islands",
    "Somalia", "South Africa", "South Korea", "South Sudan", "Spain", "Sri Lanka", "Sudan", "Suriname", "Sweden", "Switzerland",
    "Syria", "Taiwan", "Tajikistan", "Tanzania", "Thailand", "Timor-Leste", "Togo", "Tonga", "Trinidad and Tobago", "Tunisia",
    "Turkey", "Turkmenistan", "Tuvalu", "Uganda", "Ukraine", "United Arab Emirates", "United Kingdom", "United States",
    "Uruguay", "Uzbekistan", "Vanuatu", "Vatican City", "Venezuela", "Vietnam", "Yemen", "Zambia", "Zimbabwe"
  ];

  countries.forEach(country => {
    const option = document.createElement("option");
    option.value = country;
    option.textContent = country;
    select.appendChild(option);
  });

  new Choices(select, {
    searchEnabled: true,
    itemSelectText: '',
    shouldSort: true,
    placeholder: true
  });

  // Final initialization
  updateAmountButtons();
  updateTotalDisplay();
  goToStep(1);
}
</script>
<script>
function closeDonationModal() {
  const modal = window.parent.document.getElementById("donate-modal");
  if (modal) {
    modal.style.display = "none";
  } else {
    window.location.href = 'support_us.html';
  }
}
</script>
</body>
</html>