// === News Section ===
let visibleNews = 3;
const newsContainer = document.getElementById('newsContainer');
const seeMoreBtn = document.getElementById('seeMoreBtn');
const showLessBtn = document.getElementById('showLessBtn');

const newsData = [
  {
    img: 'assets/media/DSC09359.JPG',
    text: 'Our Senior boys got a chance to play in the national team, with Tanzania winning the match against the Tritons.',
    alt: 'Senior boys team playing nationally'
  },
  {
    img: 'assets/media/DSC_6826.JPG',
    text: 'TRD hosted junior touch rugby in UWC Arusha.',
    alt: 'Junior training session'
  },
  {
    img: 'assets/media/DSC08395.JPG',
    text: 'TRD boys played for the Arusha Rhinos team against Dar Leopards in Dar es Salaam, with the Rhinos winning the match.',
    alt: 'Tag rugby in schools'
  },
  {
    img: 'assets/media/DSC_4385.JPG',
    text: 'Touch rugby tournament highlights',
    alt: 'Touch rugby tournament'
  },
];

function renderNews() {
  newsContainer.innerHTML = '';

  for (let i = 0; i < visibleNews && i < newsData.length; i++) {
    const item = newsData[i];
    const box = document.createElement('div');
    box.className = 'news-box';
    box.innerHTML = `
      <img src="${item.img}" alt="${item.alt || 'TRD news image'}" />
      <p>${item.text}</p>
    `;
    newsContainer.appendChild(box);
  }

  seeMoreBtn.style.display = visibleNews >= newsData.length ? 'none' : 'inline-block';
  showLessBtn.style.display = visibleNews >= newsData.length ? 'inline-block' : 'none';
}

seeMoreBtn.addEventListener('click', () => {
  visibleNews = newsData.length;
  renderNews();
});

showLessBtn.addEventListener('click', () => {
  visibleNews = 3;
  renderNews();
});

renderNews();

// === Slideshow Rotation ===
const slides = document.querySelectorAll('.slide-container');
let currentSlide = 0;

function rotateSlides() {
  slides.forEach(slide => slide.classList.remove('active'));
  slides[currentSlide].classList.add('active');
  currentSlide = (currentSlide + 1) % slides.length;
}

setInterval(rotateSlides, 5000);

// === Mobile Menu Toggle ===
const menuToggle = document.getElementById('menuToggle');
const menuClose = document.getElementById('menuClose');
const navLinks = document.getElementById('navLinks');
const teamsToggle = document.getElementById('teamsToggle');
const teamsMenu = document.getElementById('teamsMenu');

// Open menu
menuToggle.addEventListener('click', () => {
  navLinks.classList.add('show');
  menuToggle.style.display = 'none';
  menuClose.style.display = 'block';
});

// Close menu
menuClose.addEventListener('click', () => {
  navLinks.classList.remove('show');
  menuClose.style.display = 'none';
  menuToggle.style.display = 'block';
  teamsMenu.classList.remove('show'); // Close dropdown too
});

// Auto-collapse menu when a link is clicked (on small screens)
navLinks.querySelectorAll('a').forEach(link => {
  link.addEventListener('click', () => {
    if (window.innerWidth <= 768) {
      navLinks.classList.remove('show');
      menuClose.style.display = 'none';
      menuToggle.style.display = 'block';
      teamsMenu.classList.remove('show');
    }
  });
});

// === Dropdown Toggle for Teams (Click only)
teamsToggle.addEventListener('click', (e) => {
  e.stopPropagation(); // Prevent bubbling
  teamsMenu.classList.toggle('show');
});

// Prevent dropdown from closing when clicking inside
teamsMenu.addEventListener('click', (e) => {
  e.stopPropagation();
});

// Close dropdown if clicking outside
document.addEventListener('click', (e) => {
  if (window.innerWidth <= 768 && !teamsToggle.contains(e.target)) {
    teamsMenu.classList.remove('show');
  }
});

// === Scroll-to-Top Button ===
const scrollBtn = document.getElementById("scrollTopBtn");

window.addEventListener("scroll", () => {
  scrollBtn.classList.toggle("show", window.scrollY > 300);
});

scrollBtn.addEventListener("click", (e) => {
  e.preventDefault();
  window.scrollTo({ top: 0, behavior: "smooth" });
});

// === Animated Counters ===
const counters = document.querySelectorAll('.counter');

counters.forEach(counter => {
  const updateCount = () => {
    const target = +counter.getAttribute('data-target');
    const count = +counter.innerText;
    const increment = target / 100;

    if (count < target) {
      counter.innerText = Math.ceil(count + increment);
      setTimeout(updateCount, 30);
    } else {
      counter.innerText = target;
    }
  };

  updateCount();
});