// === News Section ===
let visibleNews = 3;
const newsContainer = document.getElementById('newsContainer');
const seeMoreBtn = document.getElementById('seeMoreBtn');
const showLessBtn = document.getElementById('showLessBtn');

// === Mobile Menu Toggle ===
const menuToggle = document.getElementById('menuToggle');
const menuClose = document.getElementById('menuClose');
const navLinks = document.getElementById('navLinks');
const teamsToggle = document.getElementById('teamsToggle');
const teamsMenu = document.getElementById('teamsMenu');

// Open menu
menuToggle.addEventListener('click', () => {
  navLinks.classList.add('show');
  menuToggle.style.display = 'none';
  menuClose.style.display = 'block';
});

// Close menu
menuClose.addEventListener('click', () => {
  navLinks.classList.remove('show');
  menuClose.style.display = 'none';
  menuToggle.style.display = 'block';
  teamsMenu.classList.remove('show'); // Close dropdown too
});

// Auto-collapse menu when a link is clicked (on small screens)
navLinks.querySelectorAll('a').forEach(link => {
  link.addEventListener('click', () => {
    if (window.innerWidth <= 768) {
      navLinks.classList.remove('show');
      menuClose.style.display = 'none';
      menuToggle.style.display = 'block';
      teamsMenu.classList.remove('show');
    }
  });
});

// === Dropdown Toggle for Teams (Click only)
teamsToggle.addEventListener('click', (e) => {
  e.stopPropagation(); // Prevent bubbling
  teamsMenu.classList.toggle('show');
});

// Prevent dropdown from closing when clicking inside
teamsMenu.addEventListener('click', (e) => {
  e.stopPropagation();
});

// Close dropdown if clicking outside
document.addEventListener('click', (e) => {
  if (window.innerWidth <= 768 && !teamsToggle.contains(e.target)) {
    teamsMenu.classList.remove('show');
  }
});

// === Scroll-to-Top Button ===
const scrollBtn = document.getElementById("scrollTopBtn");

window.addEventListener("scroll", () => {
  scrollBtn.classList.toggle("show", window.scrollY > 300);
});

scrollBtn.addEventListener("click", (e) => {
  e.preventDefault();
  window.scrollTo({ top: 0, behavior: "smooth" });
});