<?php
session_start();
require 'db_config.php';

$error = "";
$success = "";

if ($_SERVER["REQUEST_METHOD"] === "POST") {
  $name = htmlspecialchars(trim($_POST['name']), ENT_QUOTES, 'UTF-8');
  $email = trim($_POST['email']);
  $password = $_POST['password'];
  $confirm = $_POST['confirm'];

  // Validation
  if (!$name || !$email || !$password || !$confirm) {
    $error = "All fields are required.";
  } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    $error = "Invalid email format.";
  } elseif (strlen($email) > 255) {
    $error = "Email is too long.";
  } elseif (strlen($name) > 100) {
    $error = "Name is too long.";
  } elseif ($password !== $confirm) {
    $error = "Passwords do not match.";
  } elseif (!preg_match('/^(?=.*[a-z])(?=.*[A-Z])(?=.*\d)(?=.*[\W_]).{8,}$/', $password)) {
    $error = "Password must be at least 8 characters, include uppercase, lowercase, number, and symbol.";
  } else {
    // Check if email exists
    $stmt = $pdo->prepare("SELECT * FROM users WHERE email = :email");
    $stmt->execute(['email' => $email]);
    if ($stmt->fetch()) {
      $error = "Email already registered.";
    } else {
      // Insert new donor
      $hashed = password_hash($password, PASSWORD_DEFAULT);
      try {
        $stmt = $pdo->prepare("INSERT INTO users (name, email, password, role) VALUES (:name, :email, :password, 'donor')");
        $stmt->execute(['name' => $name, 'email' => $email, 'password' => $hashed]);
        header("Location: login.php?registered=1");
        exit;
      } catch (PDOException $e) {
        $error = "Registration failed. Please try again.";
      }
    }
  }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Register | TRD</title>
  <link rel="stylesheet" href="style/style.css" />
  <link rel="stylesheet" href="style/lore.css" />
</head>
<body>
    <header class="header">
    <div class="header-top">
      <img src="assets/icons/trd logo transparent logo.png" alt="TRD Logo" class="logo-transparent" />
      <h1 class="org-name">Tanzania Rugby Development</h1>
    </div>
    <nav class="nav_links" id="navLinks">
      <a href="index.html" class="btn btn-light">Home</a>
      <a href="about.html">About Us</a>
    </nav>
  </header>
  <section class="register-section">
    <h2>Create Account</h2>
    <?php if ($error): ?><p style="color:red"><?= $error ?></p><?php endif; ?>
    <?php if ($success): ?><p style="color:green"><?= $success ?></p><?php endif; ?>
    <form method="POST">
      <input type="text" name="name" placeholder="Full Name" required />
      <input type="email" name="email" placeholder="Email" required />
      <input type="password" name="password" id="password" placeholder="Password" required />
      <input type="password" name="confirm" id="confirm" placeholder="Re-enter Password" required />
      <label><input type="checkbox" onclick="togglePassword()"> Show Password</label>
      <button type="submit">Register</button>
    </form>
    <p>Already registered? <a href="login.php">Log in here</a></p>
  </section>
  <footer class="footer">
  <div class="social-icons">
      <a href="https://www.facebook.com/profile.php?id=61566355871598" target="_blank"><img src="assets/icons/Facebook icon.jpg" alt="Facebook" width="45" height="45"></a>
      <a href="https://www.instagram.com/_tazania_rugby_development/" target="_blank"><img src="assets/icons/Instagram icon.jpg" alt="Instagram" width="40"></a>
      <a href="https://wa.me/255756624683" target="_blank"><img src="assets/icons/WhatsApp icon.jpg" alt="WhatsApp" width="40"></a>
    </div>
  <div class="footer-logo">
    <img src="assets/icons/trd logo transparent logo.png" alt="TRD Logo" class="logo-transparent" />
  </div>
  <p>&copy; 2025 Tanzania Rugby Development. All rights reserved.</p>
</footer>
  <script>
    function togglePassword() {
      document.getElementById("password").type =
        document.getElementById("password").type === "password" ? "text" : "password";
      document.getElementById("confirm").type =
        document.getElementById("confirm").type === "password" ? "text" : "password";
    }
  </script>
</body>
</html>