<?php
// ✅ Load Stripe PHP SDK (install via Composer or manually)
require 'vendor/autoload.php'; // or 'stripe-php/init.php' if downloaded manually

// ✅ Set your Stripe secret key (keep this hidden)
\Stripe\Stripe::setApiKey('sk_test_your_secret_key_here'); // Replace with your real secret key

// ✅ Accept JSON input from frontend
header('Content-Type: application/json');
$input = json_decode(file_get_contents("php://input"), true);

// ✅ Extract and validate required fields
$amount = isset($input['amount']) ? intval($input['amount']) : 0;
$currency = isset($input['currency']) ? strtolower($input['currency']) : 'usd';
$email = $input['email'] ?? null;

if ($amount <= 0 || !$email) {
  echo json_encode(['success' => false, 'error' => 'Invalid donation data.']);
  exit;
}

try {
  // ✅ Create a PaymentIntent with Stripe
  $paymentIntent = \Stripe\PaymentIntent::create([
    'amount' => $amount * 100, // Stripe uses cents
    'currency' => $currency,
    'description' => 'TRD Donation',
    'receipt_email' => $email,
    'metadata' => [
      'donor_name' => $input['name'] ?? '',
      'message' => $input['message'] ?? '',
      'anonymous' => $input['anonymous'] ? 'yes' : 'no',
      'country' => $input['country'] ?? '',
    ]
  ]);

  // ✅ Return client secret to frontend
  echo json_encode([
    'success' => true,
    'client_secret' => $paymentIntent->client_secret
  ]);
} catch (Exception $e) {
  // ❌ Handle errors gracefully
  echo json_encode([
    'success' => false,
    'error' => $e->getMessage()
  ]);
}
?>