<?php
session_start();
if (!isset($_SESSION['user'])) {
  header("Location: login.php");
  exit;
}

$role = strtolower($_SESSION['user']['role']);
$email = $_SESSION['user']['email'];

$host = "localhost";
$dbname = "trd_donations";
$username = "root";
$password = "";

try {
  $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $username, $password);
  $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
  die("Database connection failed: " . $e->getMessage());
} 

// Check if donor has donated OR is admin
$stmt = $pdo->prepare("SELECT COUNT(*) FROM donations WHERE email = :email");
$stmt->execute(['email' => $email]);
$hasDonated = $stmt->fetchColumn() > 0;

if ($role !== 'admin' && !$hasDonated) {
  header("Location: index.html"); // Or show a message like "No donations yet"
  exit;
}
// Update last_active timestamp for admin
$update = $pdo->prepare("UPDATE users SET last_active = NOW() WHERE email = :email");
$update->execute(['email' => $_SESSION['user']['email']]);

// Delete user
if (isset($_GET['delete_user'])) {
  $stmt = $pdo->prepare("DELETE FROM users WHERE email = :email");
  $stmt->execute(['email' => $_GET['delete_user']]);
  header("Location: admin.php?deleted=1");
  exit;
}

// Update user
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['update_user'])) {
  $stmt = $pdo->prepare("UPDATE users SET name = :name, email = :email WHERE email = :original_email");
  $stmt->execute([
    'name' => trim($_POST['name']),
    'email' => trim($_POST['email']),
    'original_email' => $_POST['original_email']
  ]);
  header("Location: admin.php?updated=1");
  exit;
}

// Export all users
if (isset($_GET['export_users'])) {
  header('Content-Type: text/csv');
  header('Content-Disposition: attachment; filename="users.csv"');
  $output = fopen('php://output', 'w');
  fputcsv($output, ['Name', 'Email', 'Role']);
  $stmt = $pdo->query("SELECT name, email, role FROM users");
  foreach ($stmt as $user) {
    fputcsv($output, [$user['name'], $user['email'], $user['role']]);
  }
  fclose($output);
  exit;
}

// Fetch users
$userStmt = $pdo->query("SELECT name, email, role, last_active FROM users ORDER BY name ASC");
$users = $userStmt->fetchAll(PDO::FETCH_ASSOC);

// Donor search
$search = $_GET['search'] ?? '';
$searchQuery = $search ? "WHERE name LIKE :search OR last_name LIKE :search OR email LIKE :search" : "";
$searchParam = $search ? ['search' => "%$search%"] : [];

$stmt = $pdo->prepare("SELECT name, last_name, email FROM donations $searchQuery GROUP BY email ORDER BY name ASC");
$stmt->execute($searchParam);
$donors = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Selected donor
$selectedEmail = $_GET['email'] ?? null;
$donations = [];
$page = $_GET['page'] ?? 1;
$limit = 10;
$offset = ($page - 1) * $limit;
$totalPages = 1;

if ($selectedEmail) {
  $countStmt = $pdo->prepare("SELECT COUNT(*) FROM donations WHERE email = :email");
  $countStmt->execute(['email' => $selectedEmail]);
  $total = $countStmt->fetchColumn();
  $totalPages = ceil($total / $limit);

  $stmt = $pdo->prepare("SELECT * FROM donations WHERE email = :email ORDER BY timestamp DESC LIMIT $limit OFFSET $offset");
  $stmt->execute(['email' => $selectedEmail]);
  $donations = $stmt->fetchAll(PDO::FETCH_ASSOC);
}

// Export donations
if (isset($_GET['export']) && $selectedEmail) {
  header('Content-Type: text/csv');
  header('Content-Disposition: attachment; filename="donations.csv"');
  $output = fopen('php://output', 'w');
  fputcsv($output, ['Amount', 'Currency', 'Message', 'Anonymous', 'Country', 'Date']);
  foreach ($donations as $donation) {
    fputcsv($output, [
      $donation['amount'],
      $donation['currency'],
      $donation['message'],
      $donation['anonymous'] ? 'Yes' : 'No',
      $donation['country'],
      $donation['timestamp']
    ]);
  }
  fclose($output);
  exit;
}

// Notify donors of upcoming event (placeholder logic)
if ($_SERVER["REQUEST_METHOD"] === "POST" && isset($_POST['notify_donors'])) {
  $eventTitle = trim($_POST['event_title']);
  $eventDate = $_POST['event_date'];

  if ($eventTitle && $eventDate) {
    // Save event
    $stmt = $pdo->prepare("INSERT INTO events (title, event_date) VALUES (:title, :date)");
    $stmt->execute(['title' => $eventTitle, 'date' => $eventDate]);

    // Fetch all donor emails
    $donors = $pdo->query("SELECT email, name FROM users WHERE role = 'donor'")->fetchAll(PDO::FETCH_ASSOC);

    // Send email to each donor
    require 'PHPMailer/PHPMailerAutoload.php';
    foreach ($donors as $donor) {
      $mail = new PHPMailer;
      $mail->isSMTP();
      $mail->Host = 'smtp.example.com'; // Replace with your SMTP server
      $mail->SMTPAuth = true;
      $mail->Username = 'your@email.com'; // Replace with your email
      $mail->Password = 'yourpassword';   // Replace with your password
      $mail->SMTPSecure = 'tls';
      $mail->Port = 587;

      $mail->setFrom('your@email.com', 'TRD');
      $mail->addAddress($donor['email'], $donor['name']);
      $mail->Subject = "Upcoming Event: $eventTitle";
      $mail->Body = "Dear {$donor['name']},\n\nWe’re excited to announce an upcoming event:\n\n📅 $eventTitle\n🗓️ Date: $eventDate\n\nThank you for being part of TRD!\n\n— Tanzania Rugby Development";

      $mail->send(); // You can add error handling here if needed
    }

    header("Location: admin.php?event_sent=1");
    exit;
  }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Wakuu | TRD</title>
  <link rel="stylesheet" href="style/style.css" />
  <style>
    body {
      font-family: Arial, sans-serif;
      background: #d6d6d6ff;
      margin: 0;
      padding: 0;
    }
    .header, .footer {
      background: #003366;
      color: white;
      padding: 15px;
      text-align: center;
    }
    .container {
      max-width: 1000px;
      margin: auto;
      background: white;
      padding: 20px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
    h2, h3 {
      color: #003366;
      margin-top: 30px;
    }
    .btn {
      background: #0066cc;
      color: white;
      padding: 8px 16px;
      border: none;
      border-radius: 4px;
      text-decoration: none;
      margin: 5px;
      display: inline-block;
      cursor: pointer;
    }
    .btn:hover {
      background: #004c99;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 15px;
    }
    th, td {
      border: 1px solid #ccc;
      padding: 10px;
      text-align: left;
    }
    th {
      background: #e0e0e0;
    }
    .status-dot {
      height: 10px;
      width: 10px;
      border-radius: 50%;
      display: inline-block;
    }
    #editModal {
      display: none;
      position: fixed;
      top: 20%;
      left: 50%;
      transform: translateX(-50%);
      background: white;
      padding: 20px;
      border: 1px solid #ccc;
      box-shadow: 0 0 10px rgba(0,0,0,0.2);
      z-index: 1000;
    }
    #userSearch {
      padding: 6px;
      width: 60%;
    }
  </style>
</head>
<body>
  <header class="header">
    <div class="header-top">
    <button class="menu-toggle" id="menuToggle">⁝</button>
    <button class="menu-close" id="menuClose">✖</button>
    <img src="assets/icons/trd logo transparent logo.png" alt="TRD Logo" class="logo-transparent" />
    <h1 class="org-name">Tanzania Rugby Development</h1>
  </div>
    <img src="assets/icons/trd logo transparent logo.png" alt="TRD Logo" style="height: 50px;" />
    <h1>Tanzania Rugby Development</h1>
    <a href="index.html" class="btn" style="position: absolute; top: 15px; right: 15px;">Home</a>
    <a href="about.html" class="btn" style="position: absolute; top: 15px; right: 100px;">About Us</a>
    <a href="logout.php" class="btn" style="position: absolute; top: 15px; right: 208px;">Logout</a>
    <a href="donor_dashboard.php" class="btn" style="position: absolute; top: 15px; right: 300px;">Donor Dashboard</a><br>
  </header>

  <div class="container">
    <?php if (isset($_GET['deleted'])): ?>
      <p style="color:green">User deleted successfully.</p>
    <?php endif; ?>
    <?php if (isset($_GET['updated'])): ?>
      <p style="color:green">User updated successfully.</p>
    <?php endif; ?>

    <h2>User Management</h2>
    <div style="display:flex; justify-content:space-between; align-items:center;">
      <input type="text" id="userSearch" placeholder="Search users...">
      <a href="?export_users=1" class="btn">Export All Users</a>
    </div>
    <p>Total Users: <?= count($users) ?> |
      Online: <?= count(array_filter($users, fn($u) => isset($u['last_active']) && (time() - strtotime($u['last_active']) < 300))) ?>
    </p>

    <table id="userTable">
      <tr>
        <th>Status</th>
        <th>Name</th>
        <th>Email</th>
        <th>Role</th>
        <th>Actions</th>
      </tr>
      <?php foreach ($users as $user): ?>
        <?php
          $isOnline = isset($user['last_active']) && (time() - strtotime($user['last_active']) < 300);
        ?>
        <tr>
          <td><span class="status-dot" style="background:<?= $isOnline ? 'green' : 'black' ?>"></span></td>
          <td><?= htmlspecialchars($user['name']) ?></td>
          <td><?= htmlspecialchars($user['email']) ?></td>
          <td><?= htmlspecialchars($user['role']) ?></td>
          <td>
            <button class="btn" onclick="openEditModal('<?= htmlspecialchars($user['name']) ?>', '<?= htmlspecialchars($user['email']) ?>')">Edit</button>
            <a href="?delete_user=<?= urlencode($user['email']) ?>" class="btn" onclick="return confirm('Delete this user?')">Delete</a>
          </td>
        </tr>
      <?php endforeach; ?>
    </table>

    <div id="editModal">
      <h3>Edit User</h3>
      <form method="POST">
        <input type="text" name="name" id="modalName" required><br><br>
        <input type="email" name="email" id="modalEmail" required><br><br>
        <input type="hidden" name="original_email" id="modalOriginalEmail">
        <button type="submit" name="update_user" class="btn">Save</button>
        <button type="button" class="btn" onclick="closeEditModal()">Cancel</button>
      </form>
    </div>

    <h2>Donor Search</h2>
    <form method="GET">
      <input type="text" name="search" placeholder="Search donors..." value="<?= htmlspecialchars($search) ?>" />
      <button type="submit" class="btn">Search</button>
    </form>

    <h3>Donor List</h3>
    <ul>
      <?php foreach ($donors as $donor): ?>
        <li>
          <a href="?email=<?= urlencode($donor['email']) ?>" class="btn">
            <?= htmlspecialchars($donor['name'] . ' ' . $donor['last_name']) ?>
          </a>
        </li>
      <?php endforeach; ?>
    </ul>

    <?php if ($selectedEmail): ?>
      <h3>Donations by <?= htmlspecialchars($selectedEmail) ?></h3>
      <a href="?email=<?= urlencode($selectedEmail) ?>&export=1" class="btn">Export to CSV</a>
      <table>
        <tr>
          <th>Amount</th>
          <th>Currency</th>
          <th>Message</th>
          <th>Anonymous</th>
          <th>Country</th>
          <th>Date</th>
        </tr>
        <?php foreach ($donations as $donation): ?>
          <tr>
            <td><?= htmlspecialchars($donation['amount']) ?></td>
            <td><?= htmlspecialchars($donation['currency']) ?></td>
            <td><?= htmlspecialchars($donation['message']) ?></td>
            <td><?= $donation['anonymous'] ? 'Yes' : 'No' ?></td>
            <td><?= htmlspecialchars($donation['country']) ?></td>
            <td><?= htmlspecialchars($donation['timestamp']) ?></td>
          </tr>
        <?php endforeach; ?>
      </table>
      <div style="margin-top: 10px;">
        <?php for ($i = 1; $i <= $totalPages; $i++): ?>
          <a href="?email=<?= urlencode($selectedEmail) ?>&page=<?= $i ?>" class="btn"><?= $i ?></a>
        <?php endfor; ?>
      </div>
    <?php endif; ?>

    <h2>Set Team Registration Deadline</h2>
    <form id="deadlineForm">
      <label for="deadline">Deadline Date & Time:</label>
      <input type="datetime-local" id="deadline" required />
      <button type="submit" class="btn">Save Deadline</button>
    </form>
    <p id="statusMessage"></p>
  </div>

  <a href="#" id="scrollTopBtn" class="scroll-top" title="Back to Top">
    <img src="assets/icons/arrow up.png" alt="Scroll to Top" />
  </a>

  <footer class="footer">
    <p>&copy; 2025 Tanzania Rugby Development. All rights reserved.</p>
  </footer>

  <script>
  const scrollBtn = document.getElementById("scrollTopBtn");

  window.addEventListener("scroll", () => {
    if (window.scrollY > 300) {
      scrollBtn.classList.add("show");
    } else {
      scrollBtn.classList.remove("show");
    }
  });

  scrollBtn.addEventListener("click", (e) => {
    e.preventDefault();
    window.scrollTo({ top: 0, behavior: "smooth" });
  });
</script>
  <script>
  // Modal logic
  function openEditModal(name, email) {
    document.getElementById("modalName").value = name;
    document.getElementById("modalEmail").value = email;
    document.getElementById("modalOriginalEmail").value = email;
    document.getElementById("editModal").style.display = "block";
  }

  function closeEditModal() {
    document.getElementById("editModal").style.display = "none";
  }

  // Real-time user search
  document.getElementById("userSearch").addEventListener("input", function () {
    const filter = this.value.toLowerCase();
    const rows = document.querySelectorAll("#userTable tr");
    rows.forEach((row, index) => {
      if (index === 0) return; // skip header
      const text = row.textContent.toLowerCase();
      row.style.display = text.includes(filter) ? "" : "none";
    });
  });

  // Notify donors form (placeholder, implement email logic as needed)
  <h2>Notify Donors of Upcoming Event</h2>
<form method="POST">
  <input type="text" name="event_title" placeholder="Event Title" required />
  <input type="date" name="event_date" required />
  <button type="submit" name="notify_donors" class="btn">Notify Donors</button>
</form>

  // Deadline form logic
  const form = document.getElementById("deadlineForm");
  const status = document.getElementById("statusMessage");

  form.addEventListener("submit", (e) => {
    e.preventDefault();
    const deadline = document.getElementById("deadline").value;
    localStorage.setItem("trdDeadline", deadline);
    status.textContent = "Deadline saved successfully: " + deadline;
  });

  const current = localStorage.getItem("trdDeadline");
  if (current) {
    status.textContent = "Current deadline: " + current;
  }

  
// === Mobile Menu Toggle ===
const menuToggle = document.getElementById('menuToggle');
const menuClose = document.getElementById('menuClose');
const navLinks = document.getElementById('navLinks');
const teamsToggle = document.getElementById('teamsToggle');
const teamsMenu = document.getElementById('teamsMenu');

// Open menu
menuToggle.addEventListener('click', () => {
  navLinks.classList.add('show');
  menuToggle.style.display = 'none';
  menuClose.style.display = 'block';
});

// Close menu
menuClose.addEventListener('click', () => {
  navLinks.classList.remove('show');
  menuClose.style.display = 'none';
  menuToggle.style.display = 'block';
  teamsMenu.classList.remove('show'); // Close dropdown too
});

// Auto-collapse menu when a link is clicked (on small screens)
navLinks.querySelectorAll('a').forEach(link => {
  link.addEventListener('click', () => {
    if (window.innerWidth <= 768) {
      navLinks.classList.remove('show');
      menuClose.style.display = 'none';
      menuToggle.style.display = 'block';
      teamsMenu.classList.remove('show');
    }
  });
});

// === Dropdown Toggle for Teams (Click only)
teamsToggle.addEventListener('click', (e) => {
  e.stopPropagation(); // Prevent bubbling
  teamsMenu.classList.toggle('show');
});

// Prevent dropdown from closing when clicking inside
teamsMenu.addEventListener('click', (e) => {
  e.stopPropagation();
});

// Close dropdown if clicking outside
document.addEventListener('click', (e) => {
  if (window.innerWidth <= 768 && !teamsToggle.contains(e.target)) {
    teamsMenu.classList.remove('show');
  }
});

// === Animated Counters ===
const counters = document.querySelectorAll('.counter');

counters.forEach(counter => {
  const updateCount = () => {
    const target = +counter.getAttribute('data-target');
    const count = +counter.innerText;
    const increment = target / 100;

    if (count < target) {
      counter.innerText = Math.ceil(count + increment);
      setTimeout(updateCount, 30);
    } else {
      counter.innerText = target;
    }
  };

  updateCount();
});
</script>
</body>
</html>