
CREATE DATABASE trd_donations CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci;

USE trd_donations;

CREATE TABLE donations (
  id INT AUTO_INCREMENT PRIMARY KEY,
  amount DECIMAL(10,2) NOT NULL,
  currency VARCHAR(10) NOT NULL,
  name VARCHAR(100) NOT NULL,
  last_name VARCHAR(100) NOT NULL,
  email VARCHAR(150) NOT NULL,
  message TEXT,
  anonymous TINYINT(1) DEFAULT 0,
  mailing_list TINYINT(1) DEFAULT 0,
  country VARCHAR(100),
  timestamp DATETIME DEFAULT CURRENT_TIMESTAMP
);

CREATE TABLE users (
  id INT AUTO_INCREMENT PRIMARY KEY,
  name VARCHAR(100),
  email VARCHAR(100) UNIQUE,
  password VARCHAR(255),
  role ENUM('admin', 'donor') DEFAULT 'donor'
);

/* Insert an admin user (password should be hashed in practice) */
INSERT INTO users (name, email, password, role)
VALUES ('Admin', 'kityyler@gmail.com', '$2y$10$XWciBzWvK6To7wMW6EMybej0c9nZVxVu01BRdcYiw25OMRHZcbZ6O', 'admin');

/* online users*/
ALTER TABLE users ADD COLUMN last_active DATETIME DEFAULT NULL;

/*events */
CREATE TABLE events (
  id INT AUTO_INCREMENT PRIMARY KEY,
  title VARCHAR(255) NOT NULL,
  event_date DATE NOT NULL,
  created_at DATETIME DEFAULT CURRENT_TIMESTAMP
);
